/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.gui.wizard;

import com.quantumdata.sct.dao.impl.TestResultsDAO;
import com.quantumdata.sct.dao.impl.TestSectionDAO;
import com.quantumdata.sct.dao.impl.XMLDAOFactory;
import com.quantumdata.sct.dao.interfaces.IPersistable;
import com.quantumdata.sct.dao.vo.TestResultVO;
import com.quantumdata.sct.dao.vo.TestResultsVO;
import com.quantumdata.sct.dao.vo.TestSectionVO;
import com.quantumdata.sct.gui.ComplianceTesterToolUI;
import com.quantumdata.sct.gui.common.MessageOptionPane;
import com.quantumdata.sct.gui.common.SCTButton;
import com.quantumdata.sct.gui.common.SCTConstants;
import com.quantumdata.sct.gui.wizard.ActivityCardItemPanel;
import com.quantumdata.sct.gui.wizard.ActivityMainPanel;
import com.quantumdata.sct.gui.wizard.PrintReportDialog;
import com.quantumdata.sct.gui.wizard.TestResultSectionPage;
import java.awt.event.ActionEvent;
import java.util.Vector;

public class TestResultWizard
extends ActivityMainPanel {
    public TestResultWizard(ComplianceTesterToolUI complianceTesterToolUI) {
        super(complianceTesterToolUI);
    }

    public void initTestResults(String string) throws Exception {
        this.clearCards();
        TestResultsDAO testResultsDAO = (TestResultsDAO)XMLDAOFactory.getTestResultsDAO(SCTConstants.getUnitStorage(string));
        TestSectionDAO testSectionDAO = (TestSectionDAO)XMLDAOFactory.getTestSectionDAO();
        IPersistable[] iPersistableArray = testResultsDAO.readAll();
        for (int i = 0; i < iPersistableArray.length; ++i) {
            TestResultsVO testResultsVO = (TestResultsVO)iPersistableArray[i];
            IPersistable[] iPersistableArray2 = testSectionDAO.readAll();
            for (int j = 0; j < iPersistableArray2.length; ++j) {
                Object object2;
                TestSectionVO testSectionVO = (TestSectionVO)iPersistableArray2[j];
                Vector<Object> vector = new Vector<Object>(testSectionVO.size());
                for (Object object2 : testResultsVO.getStepresults()) {
                    if (!testSectionVO.contains(((TestResultVO)object2).getCapabilityId())) continue;
                    vector.add(object2);
                }
                if (vector.isEmpty()) continue;
                object2 = new TestResultSectionPage(testSectionVO, vector);
                this.addCard(testSectionVO.getName(), (ActivityCardItemPanel)object2);
            }
        }
        this.validateBtn();
    }

    public void validateBtn() {
        TestResultSectionPage testResultSectionPage = (TestResultSectionPage)this.getCurrentCard();
        String string = "Test : " + (testResultSectionPage.getTestIndex() + 1) + " of " + testResultSectionPage.getTestCount();
        this.getStepCountButton().setText(string);
        if (this.isFirstPage() && this.isFirstTest()) {
            this.getBackButton().setEnabled(false);
        } else {
            this.getBackButton().setEnabled(true);
        }
        if (this.isLastPage() && this.isLastTest()) {
            this.getNextButton().setEnabled(false);
        } else {
            this.getNextButton().setEnabled(true);
        }
        this.getCancelButton().setEnabled(true);
        this.getFinishButton().setEnabled(false);
        this.getFinishButton().setVisible(false);
        this.getSecBackButton().setEnabled(true);
        this.getSecNextButton().setEnabled(true);
        this.getSecBackButton().setVisible(true);
        this.getSecNextButton().setVisible(true);
    }

    private boolean isFirstTest() {
        TestResultSectionPage testResultSectionPage = (TestResultSectionPage)this.getCurrentCard();
        return testResultSectionPage.isFirstTest();
    }

    private boolean isLastTest() {
        TestResultSectionPage testResultSectionPage = (TestResultSectionPage)this.getCurrentCard();
        return testResultSectionPage.isLastTest();
    }

    public void nextButtonAction(ActionEvent actionEvent) {
        TestResultSectionPage testResultSectionPage = (TestResultSectionPage)this.getCurrentCard();
        if (testResultSectionPage.nextButtonAction(actionEvent)) {
            super.nextButtonAction(actionEvent);
        }
        this.validateBtn();
    }

    public void backButtonAction(ActionEvent actionEvent) {
        TestResultSectionPage testResultSectionPage = (TestResultSectionPage)this.getCurrentCard();
        if (testResultSectionPage.backButtonAction(actionEvent)) {
            super.backButtonAction(actionEvent);
        }
        this.validateBtn();
    }

    public void nextSecButtonAction(ActionEvent actionEvent) {
        TestResultSectionPage testResultSectionPage = (TestResultSectionPage)this.getCurrentCard();
        if (testResultSectionPage != null) {
            testResultSectionPage.setLastIndex();
            super.nextSecButtonAction(actionEvent);
            this.validateBtn();
        }
    }

    public void backSecButtonAction(ActionEvent actionEvent) {
        TestResultSectionPage testResultSectionPage = (TestResultSectionPage)this.getCurrentCard();
        if (testResultSectionPage != null) {
            testResultSectionPage.setFirstIndex();
            super.backSecButtonAction(actionEvent);
            this.validateBtn();
        }
    }

    public void cancelButtonAction(ActionEvent actionEvent) {
        try {
            new PrintReportDialog(this.toolUI).show();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            MessageOptionPane messageOptionPane = new MessageOptionPane();
            MessageOptionPane.ShowMessage(this.toolUI, "Error printing report", "Error");
        }
    }

    protected SCTButton getCancelButton() {
        SCTButton sCTButton = super.getCancelButton();
        sCTButton.setText("HardCopy");
        sCTButton.setMnemonic('H');
        return sCTButton;
    }

    protected SCTButton getNextButton() {
        SCTButton sCTButton = super.getNextButton();
        sCTButton.setText("Test>");
        sCTButton.setMnemonic('N');
        return sCTButton;
    }

    protected SCTButton getBackButton() {
        SCTButton sCTButton = super.getBackButton();
        sCTButton.setText("<Test");
        sCTButton.setMnemonic('B');
        return sCTButton;
    }
}

